// SetIntervalDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PdfOcxDemo.h"
#include "SetIntervalDlg.h"


// CSetIntervalDlg dialog

IMPLEMENT_DYNAMIC(CSetIntervalDlg, CDialog)

CSetIntervalDlg::CSetIntervalDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSetIntervalDlg::IDD, pParent)
    , m_bIsSetup(FALSE)
    , m_iInterval(0)
{

}

CSetIntervalDlg::~CSetIntervalDlg()
{
}

//void CSetIntervalDlg::InitData(BOOL bIsSetup, int iInterval)
//{
//    m_bIsSetup = bIsSetup;
//    m_iInterval = iInterval;
//
//    UpdateData(FALSE);
//}

void CSetIntervalDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Check(pDX, IDC_CHECK_SETUP, m_bIsSetup);
    DDX_Text(pDX, IDC_EDIT_INTERVAL, m_iInterval);
    DDX_Control(pDX, IDC_CHECK_SETUP, m_checkSetup);
    DDX_Control(pDX, IDC_EDIT_INTERVAL, m_editInterval);
}

BEGIN_MESSAGE_MAP(CSetIntervalDlg, CDialog)
    ON_WM_ACTIVATE()
    ON_BN_CLICKED(IDOK, &CSetIntervalDlg::OnBnClickedOk)
    ON_BN_CLICKED(IDC_CHECK_SETUP, &CSetIntervalDlg::OnBnClickedCheckSetup)
END_MESSAGE_MAP()


// CSetIntervalDlg message handlers

void CSetIntervalDlg::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized)
{
    CDialog::OnActivate(nState, pWndOther, bMinimized);

    if (nState == WA_INACTIVE)
    {
        ShowWindow(SW_HIDE);

        OnBnClickedCheckSetup();
        UpdateData(FALSE);  // UIǸԭʾ״̬
    }
}

void CSetIntervalDlg::OnBnClickedOk()
{
    UpdateData(TRUE);

    GetParent()->SendMessage(WM_AUTOPAGE_INFO);

    OnOK();
}

void CSetIntervalDlg::OnBnClickedCheckSetup()
{
    if (m_checkSetup.GetCheck() == BST_CHECKED)
    {
        m_editInterval.EnableWindow(TRUE);
    }
    else
    {
        m_editInterval.EnableWindow(FALSE);
    }
}
